<?php
/**
Original Author
* @package		Joomla
* @subpackage VirtueMart 1.1.3 Router for Joomla! 1.5.10
* @copyright 2008, Copyright (C) E-FusionSoft Technologies Pvt. Ltd. All rights reserved.
* @author L. K. Lalitesh
* @ Website www.e-fusionsoft.com
* @ Email info@e-fusionsoft.com
* @ Date April 04, 2009
##### Fixes/Addition in 1.4 ####
>> Feed page has been made SEF
 
>> Category page url has all parent category nested (Upto 3 levels ONLY: E.g. www.yoursite.com/category/4/power-tools/outdoor-tools.html
 
>> List all products from Virtuemart module has been fixed
 
##### Issues/Bugs ####
 
When you submit an enquiry form than you are redirection to a page with a link that say 'Return to the product", since this link is broken in Virtuemart core hence it is not working with SEF (quite naturally, no? :) )
When you are logged in as an administrator in front end, admin link does not work, this is again because this link is not written using SEF mode in the module.
In Virtuemart ALL in one module, when you click on "Top" tab, links are again not SEF in VM and hence it cannot be converted into sef using this router.
---------------------------------------------------------
   Sankuru Author
---------------------------------------------------------
* @package		Joomla
* @subpackage	VirtueMart 1.1.3 Router for Joomla! 1.5.x
* @license		GNU/GPL.
* @author 		Korn Serey
* @ Website		www.sankuru.biz
* @ Email			serey@sankuru.biz
* @ Date			May 02, 2010
* @ Version		1.1.3
* @ Original            This work is base on Virtuemart router.php from www.e-fusionsoft.com. I have made a lot modifications to the original router.php to make sef url
			looks more or less sef urls created by sh404 sef component. It's also been altered to support joomfish translation of 
			category name, manufacturer name, and product name
* Modification to core Virtuemart : 
	Some virtuemart links are not written to support sef and some doesn't work without .htaccess. So it leaves me no choice but to modify the core file.
	We have added the following code to line 600 of virtuemart core file classes/ps_session.php 
	function  url($text, $createAbsoluteURI=false, $encodeAmpersands=true, $ignoreSEF=false ) {
	          ....
		if(SECUREURL==URL or substr($url,0,strlen(URL))==URL)
			{
				$url=str_replace(URL,'',$url);
				if(strpos($url,'?')!==false)
				{
					$url=str_replace('//','/','index.php'. substr($url,strpos($url,'?')));
					$url=str_replace(':/','://',$url);
				}
			}
		....
		
		//after line - $url = sefRelToAbs($url);
		if(SECUREURL==URL AND $createAbsoluteURI==true)
		{
			if(substr($url,0,strlen(URL))!=URL)
			{
				$url =substr(URL,0,strpos(URL,'/',10)) .$url;
				$url=str_replace('//','/',$url);
				$url=str_replace(':/','://',$url);
			}
		}
* This will render sef url as the following
	- Create new Virtuemart account -> http://domain_name/../create-an-account
	- Manufacturer link -> http://domain_name/../manufacturer_name
	- Product Category link -> http://domain_name/../category_name
	In Category Page
	- Feed Link  -> http://domain_name/../feed/category_name
	
	- List All Products  link -> http://domain_name/../view-all-products-in-shop	
	- View Cart -> http://domain_name/../view-your-cart-contents
	- Shop Front End Admin Link -> http://domain_name/../shop-administration
	
	- My Account / Account Maintenance -> http://domain_name/../view-your-account-details
	In My Account / Account Maintenance
	- View Order Details -> http://domain_name/../order-details/order_id
	- Edit Billing Address -> http://domain_name/../billing-information/check-out
	- Edit Shipping Address - > http://domain_name/../shipping-information/check-out
	- Edit existing Shipping Address  - > http://domain_name/../shipping-information/check-out/user_info_id
	
	- Checkout ->  http://domain_name/../check-out
	- Edit Billing Address -> http://domain_name/../billing-information/check-out
	- Edit Shipping Address - > http://domain_name/../shipping-information/check-out
	- Edit existing Shipping Address  - > http://domain_name/../shipping-information/check-out/user_info_id	
	
	- Product Detail link -> http://domain_name/../category_name/sub_category1/../product_name
	In Product Details
	- Ask question about this product -> http://domain_name/../ask-question-about-this-product/category_name/product_name
	- Recomment Product to Friend Link  -> http://domain_name/../recommend/product_name
	- Notify Link in case product is out of stock (shop.waiting_list) -> http://domain_name/../notify/product_name
	
Date November 21 2010
	Add bug fixing 
		Handle limit and limitstart for products list in category or in all products page
		-> http://domain_name/../../limit,n/limitstart,n
	Improvements
		1. Support mutiple level category
			Category Page -> http://domain_name/category1/subcategory1/subcat2/.../subcatn
			Product Details -> http://domain_name/category1/subcategory1/subcat2/.../subcatn/product-name
		2. Add charcater map 'Ä', 'ä' -> 'ae'; 'Ö', 'ö' -> 'oe'; 'Ü', 'ü' -> 'ue', 'ß' -> 'ss'. Joomla itself works that way.
		3. Fix problem with PDF, Email, and Print button in product details page and category page
			Line 987 in administrator/components/com_virtuemart/classes/htmlTools.class.php
				$link =  $sess->url('index2.php?page=shop.recommend&amp;product_id='.$product_id.'&amp;pop=1'.(vmIsJoomla('1.5') ? '&amp;tmpl=component' : ''));
				change to
				$link = 'index2.php?page=shop.recommend&amp;product_id='.$product_id.'&amp;pop=1'.(vmIsJoomla('1.5') ? '&amp;tmpl=component' : '');
			Line 1428 in administrator/components/com_virtuemart/classes/htmlTools.class.php
				function vmPopupLink( $link, $text, $popupWidth=640, $popupHeight=480, $target='_blank', $title='', $windowAttributes='' ) {
					//-- Added by Sankuru
					global $sess;
					$link = $sess->url($link);	
					//-- End Added by Sankuru
					if( $windowAttributes ) {
						$windowAttributes = ','.$windowAttributes;
					}
					return vmCommonHTML::hyperLink( $link, $text, '', $title, "onclick=\"void window.open('$link', '$target', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=$popupWidth,height=$popupHeight,directories=no,location=no".$windowAttributes."');return false;\"" );
					
				}
		4. Add 2 more SEF URL -> for Vendor link and Manufacturer link		
		
	20 Dec 2010
		Download Area link SEF
		Download File link SEF
		Edit Product link
		Shop Administration from Front End
	14 Feb 2011, Improve shipping and billing SEF , Include Unicode support and Speed up router
		
		index.php?option=com_virtuemart&page=account.shipping -> /view-your-account-details/account-shipping.html
		
		New Shipping Address
			index.php?option=com_virtuemart&page=account.shipto&next_page=account.index to /account-shipping/shipping-information.html
			index.php?option=com_virtuemart&page=account.shipto&next_page=checkout.index to /check-out/shipping-information.html
			
		Edit Shipping Address
			index.php?option=com_virtuemart&page=account.shipto&next_page=checkout.index&user_info_id=xxxxx -> /account-shipping/shipping-information/xxxxx.html
			index.php?option=com_virtuemart&page=account.shipto&next_page=account.index&user_info_id=xxxxx ->/account-shipping/shipping-information/xxxxx.html
			
		Billing Information	
			index.php?option=com_virtuemart&page=account.billing&next_page=account.index to /view-your-account-details/billing-information.html
			index.php?option=com_virtuemart&page=account.billing&next_page=checkout.index to /check-out/billing-information.html
			
		Mimic Joomla 1.6 used Unicode Alias or Unicode
		Speed up Query time by storing alias for products and categories
* Support :
	- If you see any other virtuemart links which doesn't get rendered as sef url, let us know at serey@sankuru.biz
	- We are committed to make our free extensions work bug-free. So please report to us all bugs you notice in connection with this extension.
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

define('PAGE_SHOP_BROWSE','category');
define('PAGE_SHOP_FEED','feed');
define('PAGE_PRODUCT_DETAILS','details');
define('PAGE_PRODUCT_ENQUIRY','enquiry');
define('PAGE_CHECKOUT_INDEX','checkout');
define('PAGE_ADVANCE_SEARCH','search');
//define('VMSEFDEBUG',true);
storeSEFURL();
function virtuemartBuildRoute(&$query)
{
	global $VM_SEF_LANG;
	$page = '';
	$segments = array();
	
	if(isset($query['page'])){
		$page = $query['page'];		
		unset($query['page']);
	}
	
	if(isset($query['pshop_mode']))
	{
		if($query['pshop_mode']=='admin')
			return $segments;
	}
	if($page=='product.product_form')
		return $segments;
	
	if(isset($query['flypage'])){
		unset($query['flypage']);
	}

	if(isset($query['product_id']))
	{
		if(isset($query['category_id'])==false)
			$query['category_id']=get_category_id_by_product_id($query['product_id']);
	}
	
	switch ($page) {
		
		/* Case for shop browse/catgory page */
		case 'shop.browse';		
			$allProductsList=true;
			if(isset($query['manufacturer_id']))
			{
				if($query['manufacturer_id'])
				{
					$manufacturer_id=$query['manufacturer_id'];						
					$manufacturer_alias = getmanufacturerTitle($manufacturer_id);
					$segments[] = $manufacturer_alias;
					unset($query['manufacturer_id']);	
					$allProductsList=false;					
				}
			}			
			elseif(isset($query['category_id']))
			{	
				if($query['category_id'])
				{
					$category_id=$query['category_id'];	
					$category_alias = getCategoryTitle($category_id);
					for($i=0;$i<count($category_alias);$i++)
						$segments[] = $category_alias[$i];		
					unset($query['category_id']);	
					$allProductsList=false;
				}				
			}
			
			if($allProductsList==true)
				$segments[] =convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_BROWSE_ALL_PRODUCTS_IN_SHOP'));//"products";
			if(isset($query['category']))
					unset($query['category']);	
				if(isset($query['category_id']))
					unset($query['category_id']);	
			break;
		/*End shop browse/catgory page*/
		
		/* Case for product details page */
		case 'shop.product_details':				
			$product_id_exists = false;
			$product_id = $query['product_id'];			

			if(isset($query['category_id']))
				$category_id=$query['category_id'];
			if(!$category_id)
				$category_id=get_category_id_by_product_id($product_id);
				
			$category_alias = getCategoryTitle($category_id);
				for($i=0;$i<count($category_alias);$i++)
					$segments[] = $category_alias[$i];	

			
			$segments[]=getProductTitle($product_id,$category_id);		
			
			
			if(isset($query['manufacturer_id']))
				unset($query['manufacturer_id']);
			if(isset($query['category_id']))
				unset($query['category_id']);
			if(isset($query['product_id']))
				unset($query['product_id']);
			if(isset($query['pop']))	
				unset($query['pop']);
			
			break;
		/*-------End manufacture/category/productname---------*/
		case 'shop.registration';
			$segments[] =convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CREATE_AN_ACCOUNT'));//"user-registration";
			break;
			
		case 'shop.cart';
			$segments[] =convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CART'));//"cart";
			if(isset($query['product_id']))	
				unset($query['product_id']);
			
			if(isset($query['category_id']))	
				unset($query['category_id']);
			break;		
		case 'store.index';
			$segments[] =convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_SHOP_ADMINISTRATION')); // 'administration';
			if(isset($query['pshop_mode']))	
				unset($query['pshop_mode']);
			break;
		case 'shop.search';
			$segments[] =convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ADVANCED_SEARCH')); // 'PAGE_ADVANCE_SEARCH';
			break;	
		/*Case for ASK A QUESTION ABOUT THIS PRODUCT PAGE*/
		case 'shop.ask';
			$segments[] =convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ASK_QUESTION_ABOUT_THIS_PRODUCT'));

		
			$product_id = $query['product_id'];
			if(isset($query['category_id']))
				$category_id=$query['category_id'];
			if(!$category_id)
				$category_id=get_category_id_by_product_id($product_id);					
			$category_alias = getCategoryTitle($category_id);
			for($i=0;$i<count($category_alias);$i++)
				$segments[] = $category_alias[$i];				
				
			$segments[] = getProductTitle($product_id,$category_id);
			
			if(isset($query['category_id']))	
				unset($query['category_id']);
			if(isset($query['product_id']))	
				unset($query['product_id']);	

			break;
			/*End*/
		/*
		Checkout Index page
		*/		
		case 'checkout.index';			
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT')); 			
			if(isset($query['ssl_redirect']))	
			{
				$segments[] = "ssl_redirect";
				unset($query['ssl_redirect']);
			}
			if(isset($query['redirected']))	
			{
				$segments[] = "redirected";
				unset($query['redirected']);
			}
			break;
			/** End of checkout index page */
		case 'account.billing';
			if(isset($query['next_page']) )	{
				if($query['next_page']=='checkout.index')
					$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT')); 
				if($query['next_page']=='account.index')
					$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ACCOUNT_MAINTENANCE'));
				unset($query['next_page']);				
			}
			else
				$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ACCOUNT_MAINTENANCE'));
				
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT_BILLING_INFORMATION')); 		
			break;	
		case 'account.shipping';
			if(isset($query['next_page']) )	{
				if($query['next_page']=='checkout.index')
					$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT')); 
				if($query['next_page']=='account.index')
					$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ACCOUNT_MAINTENANCE'));
				unset($query['next_page']);				
			}
			else
				$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ACCOUNT_MAINTENANCE'));
				
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_ACCOUNT_SHIPPING'));			
			break;			
		case 'account.shipto';			
			if(isset($query['next_page']) )	{
				if($query['next_page']=='checkout.index')
					$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT')); 
				if($query['next_page']=='account.shipping')
					$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_ACCOUNT_SHIPPING'));
				unset($query['next_page']);				
			}
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT_SHIPPING_INFORMATION')); 
			if(isset($query['user_info_id']) )	{
				$segments[] =$query['user_info_id'];
				unset($query['user_info_id']);				
			}
			break;
		case 'shop.tos';
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_TERMS_OF_SERVICE')); 			
			break;
		case 'account.index':			
		case 'account.all':
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ACCOUNT_MAINTENANCE')); 	
			if(isset($query['show_page']))
			{
				if($query['show_page']=='account.order_details')
				{
					$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ACCOUNT_MAINTENANCE_ORDER_DETAILS')); 	
					if(isset($query['order_id']))
						$segments[] =$query['order_id'];
					unset($query['order_id']);	
				}
				unset($query['show_page']);
			}
			break;
		/* Case for shop rss feed page */
		case 'shop.feed';
			
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_FEED'));
			
			if(isset($query['category_id'])){
				$category_alias = getCategoryTitle($query['category_id']);
				for($i=0;$i<count($category_alias);$i++)
						$segments[] = $category_alias[$i];		
						
				unset($query['category_id']);
			}			
			break;
		/*End shop browse/catgory page*/	
		
		case 'shop.recommend';
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_RECOMMEND'));					
			
			if(isset($query['product_id']) ){				
				$product_id = $query['product_id'];
				if(isset($query['category_id']))
					$category_id=$query['category_id'];
				if(!$category_id)
					$category_id=get_category_id_by_product_id($product_id);					
				$category_alias = getCategoryTitle($category_id);
					for($i=0;$i<count($category_alias);$i++)
						$segments[] = $category_alias[$i];	
						
				$segments[] = getProductTitle($product_id,$category_id);
				unset($query['product_id']);				
			}
			if(isset($query['tmpl']) )
				unset($query['tmpl']);				
			if(isset($query['pop']) )
				unset($query['pop']);				
			if(isset($query['category_id']) )	
				unset($query['category_id']);				

			break;
		case 'account.order_details';
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_ORDER_DETAILS'));
			if(isset($query['order_id']))	{
				$segments[] = $query['order_id'];
				unset($query['order_id']);
			}
			break;
		case 'shop.waiting_list';
			$segments[] = convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_NOTIFY'));	
			if(isset($query['product_id']) ){
				$product_id = $query['product_id'];
				if(isset($query['category_id']))				
					$category_id=$query['category_id'];
				if(!$category_id)
					$category_id=get_category_id_by_product_id($product_id);
				$category_alias = getCategoryTitle($category_id);
					for($i=0;$i<count($category_alias);$i++)
						$segments[] = $category_alias[$i];	
						
				$segments[] = getProductTitle($product_id,$category_id);
				unset($query['product_id']);				
			}
			if(isset($query['category_id']))
				unset($query['category_id']);
			break;
		case 'shop.manufacturer_page':
			$segments[]=convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_MANUFACTURER'));	
			if(isset($query['manufacturer_id']))
			{
				$manufacturer_id = $query['manufacturer_id'];
				$manufacturer_alias = getmanufacturerTitle($manufacturer_id);
				$segments[] = $manufacturer_alias;			
				unset($query['manufacturer_id']);
			}
			if(isset($query['output']))
				unset($query['output']);
			break;
		case 'shop.infopage':
			$segments[]=convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VENDOR'));	
			if(isset($query['vendor_id']))
			{
				$segments[] =getVendorTitle($query['vendor_id']);
				unset($query['vendor_id']);
			}
			if(isset($query['output']))
				unset($query['output']);
			break;			
		case 'shop.pdf_output':
			$segments[]=convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_PDF'));	
			$product_id = 0;
			if(isset($query['product_id']) )
				$product_id = $query['product_id'];
				
			if(isset($query['category_id']))				
				$category_id=$query['category_id'];
			if(!$category_id)
				$category_id=get_category_id_by_product_id($product_id);
			$category_alias = getCategoryTitle($category_id);
				for($i=0;$i<count($category_alias);$i++)
					$segments[] = $category_alias[$i];	
					
			if($product_id)					
				$segments[] = getProductTitle($product_id,$category_id);
					
			if(isset($query['category_id']))
				unset($query['category_id']);
			if(isset($query['product_id']))
				unset($query['product_id']);
			if(isset($query['output']))
				unset($query['output']);	
			if(isset($query['pop']))
				unset($query['pop']);	
			if(isset($query['showpage']))
				unset($query['showpage']);	
						
			break;	
		case 'shop.downloads':
			$segments[]=convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_DOWNLOAD_AREA'));	
			break;
		case 'shop.getfile':
			$segments[]=convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_DOWNLOAD_FILE'));	
			if(isset($query['category_id']))
				unset($query['category_id']);
			break;		
		case '':		
			if(trim($page)!='')
				$query['page']=$page;		
				
			if(isset($query['pop']) AND isset($query['tmpl']))
			{
				$segments[]=convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_PRINT'));	
				
				$product_id = JRequest::getInt('product_id');
				$category_id=JRequest::getInt('category_id');
				if(!$category_id)
					$category_id=get_category_id_by_product_id($product_id);					
				$category_alias = getCategoryTitle($category_id);
				for($i=0;$i<count($category_alias);$i++)
						$segments[] = $category_alias[$i];	
				if($product_id)		
					$segments[] = getProductTitle($product_id,$category_id);					
					
				unset($query['pop']);
				unset($query['tmpl']);
			}
			break;		
	}
	if(isset($query['limit']))
	{
		$segments[] =	'limit,' . $query['limit'];
		unset($query['limit']);
	}
	if(isset($query['start']) OR isset($query['limitstart']))
	{
		$segments[] ='limitstart,'.(isset($query['start'])?$query['start']:(isset($query['limitstart'])?$query['limitstart']:0));
		if(isset($query['start']))
			unset($query['start']);
		if(isset($query['limitstart']))
			unset($query['limitstart']);
	}
	$newSegments=array();
	foreach($segments as $segment)
	{
		$newSegments[]=urlencode($segment);
	}
	
	
	return $newSegments;
}
/*End of the function*/

function virtuemartParseRoute($segments)
{
	global $VM_SEF_LANG;
	$vars = array();
	$firstSegment = convert_title_to_alias($segments[0]); 
	$manufacture_id=0;
	$category_id=0;
	$product_id=0;
	
	$new_segments=array();
	foreach($segments as $segment)
	{
		$bUnset=false;
		$search='limit,';
		if(substr($segment,0,strlen($search))==$search)
		{
			$vars['limit'] = str_replace($search,'',$segment);
			$bUnset=true;
		}
		
		$search='limitstart,';
		if(substr($segment,0,strlen($search))==$search)
		{
			$vars['limitstart'] = str_replace($search,'',$segment);
			$bUnset=true;
		}
		if($bUnset==false)
			$new_segments[]=$segment;
	}
	$segments = $new_segments;
	$count_segment=count($segments);
	if($count_segment==1) // Check if it manufacturer or first level category
	{
		$manufacturer_id=get_manufacturer_id_by_alias($firstSegment);
		if($manufacturer_id==0)
			$category_id=get_category_id_by_alias($firstSegment );			
	}
	elseif($count_segment>=2) // Can be multiple level category or product details page
	{		
		$category_id=get_category_id_by_alias($segments);
		$product_id=get_product_id_by_alias($segments);
		$manufacturer_id=get_mf_id_by_product_id($product_id);
	}
	if(defined('VMSEFDEBUG'))
	{
		echo '<br>$manufacture_id : ' . $manufacturer_id;	
		echo '<br>$category_id : ' . $category_id;	
		echo '<br>$product_id : ' . $product_id;	
	}
	if($manufacturer_id>0)
	{
		$vars['page'] = "shop.browse";
		$vars['manufacturer_id']=$manufacturer_id;
	}
	if($category_id>0)
	{
		$vars['page'] = "shop.browse";
		$vars['category_id']=$category_id;
	}
	if($product_id>0)
	{
		$vars['page'] = "shop.product_details";
		$vars['product_id']=$product_id;
	}
	
	switch($firstSegment){		
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CREATE_AN_ACCOUNT'));
			$vars['page'] = "shop.registration";
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CART')):
			$vars['page'] = "shop.cart";
			break; 		
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ACCOUNT_MAINTENANCE')):
			$vars['page'] = "account.index";
			if(isset($segments[1])==true)
			{
				if(convert_title_to_alias($segments[1])==convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ACCOUNT_MAINTENANCE_ORDER_DETAILS')))
				{
					$vars['show_page']='account.order_details';
					$_POST['show_page']=$vars['show_page'];
					$_GET['show_page']=$vars['show_page'];
					$_REQUEST['show_page']=$vars['show_page'];
				}
				
				if(convert_title_to_alias($segments[1])==convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_ACCOUNT_SHIPPING')))
				{
					$vars['page']='account.shipping';
					$vars['next_page'] = "account.index";					
				}
				if(convert_title_to_alias($segments[1])==convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT_BILLING_INFORMATION')))
				{
					$vars['page']='account.billing';
					$vars['next_page'] = "account.index";
				}
			}
			if(isset($segments[2])==true)
			{
				$vars['order_id']=$segments[2];	
				$_POST['order_id']=$vars['order_id'];
				$_GET['order_id']=$vars['order_id'];
				$_REQUEST['order_id']=$vars['order_id'];		
			}
			break; 		
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_SHOP_ADMINISTRATION')):
			$vars['page'] = "store.index";
			$vars['pshop_mode'] = "admin";					
			break;
		/*This is for all products page*/
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_BROWSE_ALL_PRODUCTS_IN_SHOP')):
			$vars['page'] = "shop.browse";
			$vars['category'] = "";			
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ADVANCED_SEARCH')):
			$vars['page'] = "shop.search";					
			break;				
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_ASK_QUESTION_ABOUT_THIS_PRODUCT')): //PAGE_PRODUCT_ENQUIRY:
			$vars['page'] = "shop.ask";
			unset($segments[0]);
			$vars['category_id'] = get_category_id_by_alias($segments);
			$vars['product_id'] = get_product_id_by_alias($segments);	
			break; 
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT')):
			$vars['page'] = "checkout.index";
		
			if(isset($segments[1]) && ($segments[1]=="ssl_redirect")){
				$vars['ssl_redirect'] = 1;
				$vars['redirected'] = 1;
			}

			if(isset($segments[2]) && ($segments[2]=="redirected")){
				$vars['redirected'] = 1;
			}
			if(isset($segments[1]))
			{
				if(convert_title_to_alias($segments[1])==convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT_SHIPPING_INFORMATION')))
				{
					$vars['page']='account.shipto';
					$vars['next_page'] = "checkout.index";
					if(isset($segments[2]))
						$vars['user_info_id'] =$segments[2];						
				}				
				if(convert_title_to_alias($segments[1])==convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT_BILLING_INFORMATION')))
				{
					$vars['page']='account.billing';
					$vars['next_page'] = "checkout.index";
				}
			}
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT_BILLING_INFORMATION')):
			$vars['page'] = "account.billing";
			if(isset($segments[1])){
				$vars['next_page'] = "checkout.index";
			}
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_ACCOUNT_SHIPPING')):
			$vars['page'] = "account.shipping";
			
			if(isset($segments[1]))
			{
				if(convert_title_to_alias($segments[1])==convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT')))
				{			
					$vars['page']='account.shipto';
					$vars['next_page'] = "checkout.index";
				}
				if(convert_title_to_alias($segments[1])==convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT_SHIPPING_INFORMATION')))
				{			
					$vars['page']='account.shipto';
					$vars['next_page'] = "account.shipping";
				}
			}
			if(isset($segments[2]))
			{
				$vars['user_info_id'] =$segments[2];
			}
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_CHECKOUT_SHIPPING_INFORMATION')):
			$vars['page'] = "account.shipto";
			if($segments[1]){
				$vars['next_page'] = "checkout.index";
			}
			if($segments[2]){
				$vars['user_info_id'] =$segments[2];
			}
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_TERMS_OF_SERVICE')):
			$vars['page'] = "shop.tos";				
			break;	
		
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VM_FEED')):
			$vars['page'] = "shop.feed";
			unset($segments[0]);
			$vars['category_id'] = get_category_id_by_alias($segments);
			
			break;	
			
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_RECOMMEND')):
			$vars['page'] = "shop.recommend";
			$vars['pop'] = 1;
			$vars['tmpl']= "component";
			unset($segments[0]);
			$category_id=get_category_id_by_alias($segments);
			$product_id=get_product_id_by_alias($segments);			
			$vars['category_id']=$category_id;
			$vars['product_id']=$product_id;
			
			break;	
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_ORDER_DETAILS')):
			$vars['page'] = "account.order_details";
			$vars['order_id'] = $segments[1];				
			break;		
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_NOTIFY')):
			$vars['page'] = "shop.waiting_list";
			if(count($segments)==2)
			{
				$vars['product_id'] =get_product_id_by_alias($segments[1]);
			}
			else
			{
				unset($segments[0]);
				$vars['category_id'] = get_category_id_by_alias($segments);
				$vars['product_id'] = get_product_id_by_alias($segments);
			}
			break;	
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_PRINT')):
			$vars['pop']=1;
			$vars['tmpl']='component';
			unset($segments[0]);
			$vars['category_id'] = get_category_id_by_alias($segments);
			$vars['product_id'] = get_product_id_by_alias($segments);
			$vars['page']='shop.browse';
			if($vars['product_id'])
				$vars['page']='shop.product_details';
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_MANUFACTURER')):	
			$vars['page']='shop.manufacturer_page';			
			$vars['manufacturer_id']=get_manufacturer_id_by_alias($segments[1]);
			$vars['output']='lite';
			$vars['tmpl']='component';	
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_VENDOR')):	
			$vars['page']='shop.infopage';			
			$vars['vendor_id']=get_vendor_id_by_alias($segments[1]);
			$vars['output']='lite';
			$vars['tmpl']='component';	
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_DOWNLOAD_AREA')):	
			$vars['page']='shop.downloads';		
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_DOWNLOAD_FILE')):		
			$vars['page'] = 'shop.getfile';
			break;
		case convert_title_to_alias($VM_SEF_LANG->_('VM_SEF_PDF')):
			$vars['page']='shop.pdf_output';
			$vars['pop']=1;
			$vars['output']='pdf';
			
			unset($segments[0]);
			$vars['category_id'] = get_category_id_by_alias($segments);
			$vars['product_id'] = get_product_id_by_alias($segments);
			$vars['showpage']='shop.browse';
			if($vars['product_id'])
				$vars['showpage']='shop.product_details';					

			break;		
	}	
	return $vars;
}

function convert_title_to_alias($title)
{
	$chacters=array(','=>'-',';'=>'-','/'=>'-');
	$title = str_replace(
		array_keys($chacters),
		array_values($chacters),
		$title
		);
	return stringURLUnicodeSlug($title);  // Use unicode (mimic J 1.6)
	//return stringURLSafe($title); // Use unicode aliase (mimic J 1.6)
}

 function stringURLUnicodeSlug($string)
{
	//replace double byte whitespaces by single byte (Far-East languages)
	$str = preg_replace('/\xE3\x80\x80/', ' ', $string);


	// remove any '-' from the string as they will be used as concatenator.
	// Would be great to let the spaces in but only Firefox is friendly with this

	$str = str_replace('-', ' ', $str);

	// replace forbidden characters by whitespaces
	$str = preg_replace( '#[:\#\*"@+=;!&\.%()\]\/\'\\\\|\[]#',"\x20", $str );

	//delete all '?'
	$str = str_replace('?', '', $str);

	//trim white spaces at beginning and end of alias, make lowercase
	$str = trim(JString::strtolower($str));

	// remove any duplicate whitespace and replace whitespaces by hyphens
	$str =preg_replace('#\x20+#','-', $str);
	return $str;
}
function stringURLSafe($title)
{
	$alias = str_replace(':','-',$title);
	$alias = str_replace('-', ' ', $alias);
	$alias = utf8_latin_to_ascii($alias);

	// convert certain symbols to letter representation
	$alias = str_replace(array('&', '"', '<', '>'), array('a', 'q', 'l', 'g'), $alias);
	
	// lowercase and trim
	$alias = trim(strtolower($alias));
	// remove any duplicate whitespace, and ensure all characters are alphanumeric
	$alias = preg_replace(array('/\s+/','/[^A-Za-z0-9\-]/'), array('-',''), $alias);
	
	//$alias = JFilterOutput::stringURLSafe(str_replace(':','-',$title));
	while(strpos($alias,'--')!==false)
	{
		$alias = str_replace('--','-',$alias);		
	}
	return $alias;
}
function utf8_latin_to_ascii( $string, $case=0 )
{
	static $UTF8_LOWER_ACCENTS = NULL;
	static $UTF8_UPPER_ACCENTS = NULL;

	if($case <= 0)
	{
		if ( is_null($UTF8_LOWER_ACCENTS) ) 
		{
			$UTF8_LOWER_ACCENTS = array(
			'à' => 'a', 'ô' => 'o', 'ď' => 'd', 'ḟ' => 'f', 'ë' => 'e', 'š' => 's', 'ơ' => 'o',
			'ß' => 'ss', 'ă' => 'a', 'ř' => 'r', 'ț' => 't', 'ň' => 'n', 'ā' => 'a', 'ķ' => 'k',
			'ŝ' => 's', 'ỳ' => 'y', 'ņ' => 'n', 'ĺ' => 'l', 'ħ' => 'h', 'ṗ' => 'p', 'ó' => 'o',
			'ú' => 'u', 'ě' => 'e', 'é' => 'e', 'ç' => 'c', 'ẁ' => 'w', 'ċ' => 'c', 'õ' => 'o',
			'ṡ' => 's', 'ø' => 'o', 'ģ' => 'g', 'ŧ' => 't', 'ș' => 's', 'ė' => 'e', 'ĉ' => 'c',
			'ś' => 's', 'î' => 'i', 'ű' => 'u', 'ć' => 'c', 'ę' => 'e', 'ŵ' => 'w', 'ṫ' => 't',
			'ū' => 'u', 'č' => 'c', 'ö' => 'oe', 'è' => 'e', 'ŷ' => 'y', 'ą' => 'a', 'ł' => 'l',
			'ų' => 'u', 'ů' => 'u', 'ş' => 's', 'ğ' => 'g', 'ļ' => 'l', 'ƒ' => 'f', 'ž' => 'z',
			'ẃ' => 'w', 'ḃ' => 'b', 'å' => 'a', 'ì' => 'i', 'ï' => 'i', 'ḋ' => 'd', 'ť' => 't',
			'ŗ' => 'r', 'ä' => 'ae', 'í' => 'i', 'ŕ' => 'r', 'ê' => 'e', 'ü' => 'ue', 'ò' => 'o',
			'ē' => 'e', 'ñ' => 'n', 'ń' => 'n', 'ĥ' => 'h', 'ĝ' => 'g', 'đ' => 'd', 'ĵ' => 'j',
			'ÿ' => 'y', 'ũ' => 'u', 'ŭ' => 'u', 'ư' => 'u', 'ţ' => 't', 'ý' => 'y', 'ő' => 'o',
			'â' => 'a', 'ľ' => 'l', 'ẅ' => 'w', 'ż' => 'z', 'ī' => 'i', 'ã' => 'a', 'ġ' => 'g',
			'ṁ' => 'm', 'ō' => 'o', 'ĩ' => 'i', 'ù' => 'u', 'į' => 'i', 'ź' => 'z', 'á' => 'a',
			'û' => 'u', 'þ' => 'th', 'ð' => 'dh', 'æ' => 'ae', 'µ' => 'u', 'ĕ' => 'e', 'œ' => 'oe',
			);
		}

		$string = str_replace(
		array_keys($UTF8_LOWER_ACCENTS),
		array_values($UTF8_LOWER_ACCENTS),
		$string
		);
	}

	if($case >= 0)
	{
		if ( is_null($UTF8_UPPER_ACCENTS) ) 
		{
			$UTF8_UPPER_ACCENTS = array(
			'À' => 'A', 'Ô' => 'O', 'Ď' => 'D', 'Ḟ' => 'F', 'Ë' => 'E', 'Š' => 'S', 'Ơ' => 'O',
			'Ă' => 'A', 'Ř' => 'R', 'Ț' => 'T', 'Ň' => 'N', 'Ā' => 'A', 'Ķ' => 'K',
			'Ŝ' => 'S', 'Ỳ' => 'Y', 'Ņ' => 'N', 'Ĺ' => 'L', 'Ħ' => 'H', 'Ṗ' => 'P', 'Ó' => 'O',
			'Ú' => 'U', 'Ě' => 'E', 'É' => 'E', 'Ç' => 'C', 'Ẁ' => 'W', 'Ċ' => 'C', 'Õ' => 'O',
			'Ṡ' => 'S', 'Ø' => 'O', 'Ģ' => 'G', 'Ŧ' => 'T', 'Ș' => 'S', 'Ė' => 'E', 'Ĉ' => 'C',
			'Ś' => 'S', 'Î' => 'I', 'Ű' => 'U', 'Ć' => 'C', 'Ę' => 'E', 'Ŵ' => 'W', 'Ṫ' => 'T',
			'Ū' => 'U', 'Č' => 'C', 'Ö' => 'Oe', 'È' => 'E', 'Ŷ' => 'Y', 'Ą' => 'A', 'Ł' => 'L',
			'Ų' => 'U', 'Ů' => 'U', 'Ş' => 'S', 'Ğ' => 'G', 'Ļ' => 'L', 'Ƒ' => 'F', 'Ž' => 'Z',
			'Ẃ' => 'W', 'Ḃ' => 'B', 'Å' => 'A', 'Ì' => 'I', 'Ï' => 'I', 'Ḋ' => 'D', 'Ť' => 'T',
			'Ŗ' => 'R', 'Ä' => 'Ae', 'Í' => 'I', 'Ŕ' => 'R', 'Ê' => 'E', 'Ü' => 'Ue', 'Ò' => 'O',
			'Ē' => 'E', 'Ñ' => 'N', 'Ń' => 'N', 'Ĥ' => 'H', 'Ĝ' => 'G', 'Đ' => 'D', 'Ĵ' => 'J',
			'Ÿ' => 'Y', 'Ũ' => 'U', 'Ŭ' => 'U', 'Ư' => 'U', 'Ţ' => 'T', 'Ý' => 'Y', 'Ő' => 'O',
			'Â' => 'A', 'Ľ' => 'L', 'Ẅ' => 'W', 'Ż' => 'Z', 'Ī' => 'I', 'Ã' => 'A', 'Ġ' => 'G',
			'Ṁ' => 'M', 'Ō' => 'O', 'Ĩ' => 'I', 'Ù' => 'U', 'Į' => 'I', 'Ź' => 'Z', 'Á' => 'A',
			'Û' => 'U', 'Þ' => 'Th', 'Ð' => 'Dh', 'Æ' => 'Ae', 'Ĕ' => 'E', 'Œ' => 'Oe',
			);
		}
		$string = str_replace(
		array_keys($UTF8_UPPER_ACCENTS),
		array_values($UTF8_UPPER_ACCENTS),
		$string
		);
	}

	return $string;
}

/*
This function returns category/subcatgory alias string
*/
function getCategoryTitle($id) // Mutiple level category ->Build
{
	$db		= & JFactory::getDBO();	
	$category=array();
	$category[]=$id;
	$category_id=$id;
	while(true)
	{
		$query="SELECT * FROM `#__vm_category_xref` WHERE `category_child_id`={$category_id}";
		$db->setQuery($query);
		$row=$db->loadObject();
		if($row->category_parent_id==0)
			break;
		else
		{
			$category[]=$row->category_parent_id;
			$category_id=$row->category_parent_id;
		}	
	}	
	$category=array_reverse($category);	
	$category_alias=array();
	for($i=0;$i<count($category);$i++)
	{
		$category_id=$category[$i];
		$query = "SELECT `alias`
			FROM #__vm_category_alias
			WHERE `category_id`={$category_id}";			
		$db->setQuery($query);	
		$category_alias[] =$db->loadResult();
	}
	return $category_alias;
}

function getProductTitle($id,$category_id=null)
{
	$db	= & JFactory::getDBO();
	$query = 'SELECT `alias`
			FROM #__vm_product_alias
			WHERE `product_id` = ' . (int) $id;	
	$db->setQuery($query);
	$product_name = $db->loadResult();
	return $product_name;
}

function getVendorTitle($id)
{
	$db	= & JFactory::getDBO();
	$query = 'SELECT  vendor_store_name ,vendor_id  
			FROM #__vm_vendor   
			WHERE vendor_id  = ' . (int) $id;
	$db->setQuery($query);
	return convert_title_to_alias($db->loadResult());	
}
function get_Vendor_id_by_alias($alias) // MF name will be prefix with 'm-' in case of MF name and Category name is the same
{
	$db=JFactory::getDBO();
	$query="SELECT vendor_store_name,vendor_id 
			FROM #__vm_vendor";
	$db->setQuery($query);
	$rows=$db->loadObjectList();
	$alias = convert_title_to_alias($alias);
	foreach($rows as $row)
	{
		if(convert_title_to_alias($row->vendor_store_name)==$alias)
			return $row->vendor_id;
	}	
	return 0;
}
function getmanufacturerTitle($id){
	$db	= & JFactory::getDBO();
	$query = 'SELECT  mf_name ,manufacturer_id 
			FROM #__vm_manufacturer   
			WHERE manufacturer_id = ' . (int) $id;
	$db->setQuery($query);
	$row=$db->loadObject();
	if(!$row)
		return '';
		
	$mf_name = $row->mf_name;
	
	if(check_category_by_mf($mf_name))
		$mf_name =  convert_title_to_alias($row->manufacturer_id.'-'.$mf_name);	
	else
		$mf_name = convert_title_to_alias($mf_name);	
	return $mf_name;
}
function get_manufacturer_id_by_alias($alias) // MF name will be prefix with 'm-' in case of MF name and Category name is the same
{
	$db=JFactory::getDBO();
	$query="SELECT manufacturer_id,mf_name 
			FROM #__vm_manufacturer";
	$db->setQuery($query);
	$rows=$db->loadObjectList();
	$alias = convert_title_to_alias($alias);
	foreach($rows as $row)
	{
		if(convert_title_to_alias($row->mf_name)==$alias OR convert_title_to_alias($row->manufacturer_id.'-'.$row->mf_name)==$alias) 
		{
			if(check_category_by_mf($row->mf_name))
			{
				if($row->manufacturer_id . '-'.convert_title_to_alias($row->mf_name)==$alias)
					return $row->manufacturer_id;
			}
			else
			{
				return $row->manufacturer_id;
			}
		}
	}	
	return 0;
}

function get_category_id_by_alias($alias) // Mutiple level category ->Parse
{
	$db=JFactory::getDBO();
	$query="SELECT category_id,category_name FROM #__vm_category";
	$db->setQuery($query);
	$rows=$db->loadObjectList();
	$segments=array();
	if(is_array($alias))
		$segments = $alias;
	else
		$segments[] = $alias;
	
	$existing_alias=$segments;
	$category_parent_id=0;

	foreach($segments as $i=>$value)
	{
		$alias=$db->Quote(convert_title_to_alias($value));
		$query="SELECT `category_id` 
				FROM `#__vm_category_alias` 
				WHERE `alias`={$alias}";
		$db->setQuery($query);
		$category_parent_id=intval($db->loadResult());
		if($category_parent_id)
			unset($existing_alias[$i]);
		else
			$category_parent_id=$old_category_id;
			
		$old_category_id=$category_parent_id;
	}
	$alias = $existing_alias;
	return $category_parent_id;
}
function get_category_id_by_alias_remove_segments(&$alias) // Mutiple level category ->Parse
{
	$db=JFactory::getDBO();
	$segments=array();
	if(is_array($alias))
		$segments = $alias;
	else
		$segments[] = $alias;
	
	$existing_alias=$segments;
	$category_parent_id=0;
	foreach($segments as $i=>$value)
	{
		$alias=$db->Quote(convert_title_to_alias($value));
		$query="SELECT `category_id` 
				FROM `#__vm_category_alias` 
				WHERE `alias`={$alias}";
		$db->setQuery($query);
		$category_parent_id=intval($db->loadResult());
		if($category_parent_id)
			unset($existing_alias[$i]);
		else
			$category_parent_id=$old_category_id;
			
		$old_category_id=$category_parent_id;		
	}
	$alias = $existing_alias;
	return $category_parent_id;
}
function get_product_id_by_alias($alias)
{
	if(is_array($alias))
		$segments = $alias;
	else
		$segments[] = $alias;
	
	$db=JFactory::getDBO();
	$category_id=get_category_id_by_alias_remove_segments($segments);
	if(count($segments)==0)
		return 0;
		
	foreach($segments as $segment)
	{
		$product_alias = $segment;
		break;
	}
	$product_alias=$db->Quote( convert_title_to_alias($product_alias));
	$query="SELECT `product_id` FROM `#__vm_product_alias` WHERE `alias`={$product_alias}";
	$db->setQuery($query);
	return intval($db->loadResult());
	
}
function get_mf_id_by_product_id($product_id)
{
	$db=JFactory::getDBO();
	$query="SELECT #__vm_manufacturer.manufacturer_id 
			FROM #__vm_manufacturer,#__vm_product_mf_xref
			WHERE #__vm_manufacturer.manufacturer_id=#__vm_product_mf_xref.manufacturer_id 
				AND #__vm_product_mf_xref.product_id={$product_id}";
	$db->setQuery($query);
	return intval($db->loadResult());
}
function get_category_id_by_product_id($product_id)
{
	$db=JFactory::getDBO();
	$query="SELECT #__vm_category.category_id 
			FROM #__vm_category,#__vm_product_category_xref
			WHERE #__vm_category.category_id=#__vm_product_category_xref.category_id 
				AND `#__vm_category`.`category_publish`='Y'
				AND #__vm_product_category_xref.product_id={$product_id}";
	$db->setQuery($query);
	return intval($db->loadResult());
}
function check_category_by_mf($mf_name)
{
	$db	= & JFactory::getDBO();
	$query="SELECT COUNT(*)
				FROM `#__vm_category`, `#__vm_category_xref`
				WHERE `#__vm_category`.`category_id` = `#__vm_category_xref`.`category_child_id`
				AND `#__vm_category_xref`.`category_parent_id`=0
				AND `#__vm_category`.`category_publish` ='Y'
				AND `#__vm_category`.`category_name`=" .$db->Quote($mf_name);
	$db->setQuery($query);
	return  ($db->loadResult()>0);	
}
function check_duplicated_name($name,$category_id=0,$product_id=0)
{
	$db	= & JFactory::getDBO();
	$query="SELECT COUNT(*)
				FROM `#__vm_category_alias`
				WHERE `#__vm_category_alias`.`alias`=" .$db->Quote($name);
	if($category_id)
		$query .=" AND `#__vm_category_alias`.`category_id`!='{$category_id}'";
	$db->setQuery($query);
	if(defined('VMSEFDEBUG'))
		echo $db->_sql . '<br />';
	if($db->loadResult()>0)
		return true;
		
	$query="SELECT COUNT(*)
				FROM `#__vm_product_alias`
				WHERE `#__vm_product_alias`.`alias`=" .$db->Quote($name);
	if($product_id)
		$query .=" AND `#__vm_product_alias`.`product_id`!='{$product_id}'";
		
	$db->setQuery($query);
	if(defined('VMSEFDEBUG'))
		echo $db->_sql . '<br /><br />';
	if($db->loadResult()>0)
		return true;
		
	return false;
}

function storeSEFURL()
{
	static $loaded;
	if(!$loaded)
	{
		$db=JFactory::getDBO();		
		//----------- Category Alias
		$query="SELECT #__vm_category.category_id, #__vm_category.category_name,#__vm_category_alias.category_id as alias_category_id
					FROM #__vm_category LEFT JOIN #__vm_category_alias
					ON #__vm_category.category_id=#__vm_category_alias.category_id
					WHERE (#__vm_category.mdate>#__vm_category_alias.mdate OR #__vm_category_alias.mdate IS NULL)
					ORDER BY #__vm_category.category_id";
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		foreach($rows as $row)
		{
			$category_id=$db->Quote($row->category_id);
			$alias = convert_title_to_alias($row->category_name);
			if(check_duplicated_name($alias,$row->category_id))
			$alias = convert_title_to_alias($row->category_id . '-'. $row->category_name);
			$alias =$db->Quote($alias);
			$mdate=$db->Quote(time());
			if(trim($row->alias_category_id)=='')
				$q="INSERT INTO #__vm_category_alias 
						SET `category_id`={$category_id},`alias`={$alias},`mdate`={$mdate}";
			else
				$q="UPDATE #__vm_category_alias 
						SET `alias`={$alias},`mdate`={$mdate}
						WHERE `category_id`={$category_id}";
			$db->setQuery($q);			
			$db->query();
			if(defined('VMSEFDEBUG'))
				echo $db->_sql . '<br /><br />';
		}	
		//----------- Product Alias
		$query="SELECT #__vm_product.product_id, #__vm_product.product_sku, #__vm_product.product_name,#__vm_product_alias.product_id as alias_product_id
					FROM #__vm_product LEFT JOIN #__vm_product_alias
					ON #__vm_product.product_id=#__vm_product_alias.product_id
					WHERE (#__vm_product.mdate>#__vm_product_alias.mdate OR #__vm_product_alias.mdate IS NULL)
					ORDER BY #__vm_product.product_id";
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		foreach($rows as $row)
		{
			$product_id=$db->Quote($row->product_id);
			
			$alias = convert_title_to_alias($row->product_name);
			if(check_duplicated_name($alias,0,$row->product_id))
			{
				$alias = convert_title_to_alias($row->product_sku . '-'. $row->product_name);
				if(check_duplicated_name($alias,0,$row->product_id))	
					$alias = convert_title_to_alias($row->product_id . '-'.$row->product_sku . '-'. $row->product_name);
			}
			$alias =$db->Quote($alias);
			$mdate=$db->Quote(time());
			if(trim($row->alias_product_id)=='')
				$q="INSERT INTO #__vm_product_alias 
						SET `product_id`={$product_id},`alias`={$alias},`mdate`={$mdate}";
			else
				$q="UPDATE #__vm_product_alias 
						SET `alias`={$alias},`mdate`={$mdate}
						WHERE `product_id`={$product_id}";
			$db->setQuery($q);
			$db->query();
			if(defined('VMSEFDEBUG'))
				echo $db->_sql . '<br /><br />';
		}
				
	}	
	$loaded=true;
}
class vm_sef_language
{
	function vm_sef_language()
	{
		$db=JFactory::getDBO();
		
		$query="CREATE TABLE IF NOT EXISTS `#__vm_sef_language` (
					`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
					`lang_key` VARCHAR( 255 ) NULL ,
					`lang` VARCHAR( 255 ) NULL
				) ;";
		$db->setQuery($query);
		$db->query();
		
		$langvars = array (
			'VM_SEF_VM_CREATE_AN_ACCOUNT' => 'Create an account',		
			'VM_SEF_VM_CART' => 'View Your Cart Contents',
			
			'VM_SEF_VM_ACCOUNT_MAINTENANCE' => 'View your account details',	
			'VM_SEF_VM_ACCOUNT_MAINTENANCE_ORDER_DETAILS' => 'Order Details',	
			
			
			'VM_SEF_VM_SHOP_ADMINISTRATION' => 'Shop Administration',	
			
			'VM_SEF_VM_BROWSE_ALL_PRODUCTS_IN_SHOP' => 'View All Products in Shop',
			
			'VM_SEF_VM_ADVANCED_SEARCH' => 'Advanced search',
			
			'VM_SEF_VM_ASK_QUESTION_ABOUT_THIS_PRODUCT' => 'Ask Question About This Product',
			
			'VM_SEF_VM_CHECKOUT' => 'Check out',
			'VM_SEF_VM_CHECKOUT_BILLING_INFORMATION' => 'Billing Information',
			'VM_SEF_VM_CHECKOUT_SHIPPING_INFORMATION' => 'Shipping Information',
			
			'VM_SEF_VM_TERMS_OF_SERVICE' => 'Terms of Service',
			
			'VM_SEF_VM_FEED' => 'Feed',
			
			'VM_SEF_ACCOUNT_SHIPPING'=>'Account Shipping',
			'VM_SEF_RECOMMEND'=>'Recommend',
			'VM_SEF_ORDER_DETAILS'=>'Order Details',
			'VM_SEF_NOTIFY'=>'Notify',
			'VM_SEF_PRINT'=>'Print',
			'VM_SEF_PDF'=>'Pdf',			
			'VM_SEF_MANUFACTURER'=>'Manufacturer',				
			'VM_SEF_VENDOR'=>'Vendor',				
			'VM_SEF_DOWNLOAD_AREA'=>'Download Area',				
			'VM_SEF_DOWNLOAD_FILE'=>'Download File',
			);			
			
		foreach($langvars as $key=>$value)
		{
			$query="SELECT count(*) FROM #__vm_sef_language WHERE `lang_key`=" . $db->Quote($key);
			$db->setQuery($query);
			if($db->loadResult()==0)
			{
				$query='INSERT INTO #__vm_sef_language SET '
						. ' `lang_key`=' .$db->Quote($key)
						. ', `lang`=' .$db->Quote($value);
				$db->setQuery($query);
				$db->query();
			}
		}
	}
	function _($key)
	{
		$db=JFactory::getDBO();
		$query="SELECT id ,`lang` FROM #__vm_sef_language WHERE `lang_key`=" . $db->Quote($key);
		$db->setQuery($query);
		$row=$db->loadObject();
		return $row->lang;
	}
}
global $VM_SEF_LANG;
$VM_SEF_LANG=new vm_sef_language;
?>