<?php
/**
* @package		Joomla
* @subpackage	VirtueMart 1.1.4 Router for Joomla! 1.5.14
* @copyright	2008, Copyright (C) E-FusionSoft Technologies Pvt. Ltd. All rights reserved.
* @license		GNU/GPL.
* @author 		L. K. Lalitesh
* @ Website		www.e-fusionsoft.com
* @ Email		info@e-fusionsoft.com
* @ Date		July 19, 2009
* @ Version		1.1.4

## Bugs fixed in Version 1.1.4
>> If SSL is enabled, checkout pages have https
>>

*/

defined( '_JEXEC' ) or die( 'Restricted access' );

define('PAGE_SHOP_BROWSE','category');
define('PAGE_SHOP_FEED','feed');
define('PAGE_PRODUCT_DETAILS','details');
define('PAGE_PRODUCT_ENQUIRY','enquiry');
define('PAGE_CHECKOUT_INDEX','checkout');
define('PAGE_ADVANCE_SEARCH','search');

function virtuemartBuildRoute(&$query)
{

	$page = '';
	$segments = array();

	if(isset($query['page'])){
		$page = $query['page'];
		unset($query['page']);
	}

	if(isset($query['flypage'])){
		unset($query['flypage']);
	}



	switch ($page) {

		/* Case for shop browse/catgory page */
		case 'shop.browse';

			if(isset($query['category_id'])){
				$segments[] = PAGE_SHOP_BROWSE;
				$segments[] = $query['category_id'];
				$category_alias = getCategoryTitle($query['category_id']);
				$segments[] = $category_alias;
				unset($query['category_id']);

			}else{
				$segments[] = "products";
				unset($query['category']);
			}



		break;
		/*End shop browse/catgory page*/


		/* Case for shop rss feed page */
		case 'shop.feed';

			$segments[] = PAGE_SHOP_FEED;

			if(isset($query['category_id'])){
				$segments[] = $query['category_id'];
				$category_alias = getCategoryTitle($query['category_id']);
				$segments[] = $category_alias;
				unset($query['category_id']);
			}
		break;
		/*End shop browse/catgory page*/


		/* Case for product details page */
		case 'shop.product_details';
			$segments[] = PAGE_PRODUCT_DETAILS;
			$product_id_exists = false;
			if(isset($query['product_id']))	{
				$segments[] = $query['product_id'];
				$product_id_exists = true;
				$pid = $query['product_id'];
				unset($query['product_id']);
			}

			if(isset($query['category_id'])){
				$segments[] = $query['category_id'];
				$category_alias = getCategoryTitle($query['category_id']);
				$segments[] = $category_alias;
				unset($query['category_id']);
			}


			if($product_id_exists)	{
				$product_alias = getProductTitle($pid);
				$segments[] = $product_alias;
			}

		break;
		/*End shop browse/catgory page*/


		/*Case for ASK A QUESTION ABOUT THIS PRODUCT PAGE*/
		case 'shop.ask';
			$segments[] =PAGE_PRODUCT_ENQUIRY;

			if(isset($query['category_id']))	{
				$segments[] = $query['category_id'];
				unset($query['category_id']);
			}

			if(isset($query['product_id']))	{
				$segments[] = $query['product_id'];
				$product_id_exists = true;
				$pid = $query['product_id'];
				unset($query['product_id']);
			}

			if($product_id_exists)	{
				$product_alias = getProductTitle($pid);
				$segments[] = $product_alias;
			}

		break;
		/*End*/


		/*
		Checkout Index page
		*/
		case 'checkout.index';
		$segments[] = PAGE_CHECKOUT_INDEX;


		if(isset($query['ssl_redirect']))	{
			$segments[] = "ssl_redirect";
			unset($query['ssl_redirect']);
		}

		if(isset($query['redirected']))	{
			$segments[] = "redirected";
			unset($query['redirected']);
		}


		break;
		/** End of checkout index page */


		case 'account.billing';
			$segments[] ="account-billing";
			if(isset($query['next_page']) )	{
				$segments[] = "checkout";
				unset($query['next_page']);
			}
		break;


		case 'account.shipto';
			$segments[] ="account-shipto";
			if(isset($query['next_page']) )	{
				$segments[] = "checkout";
				unset($query['next_page']);
			}
		break;



		case 'account.shipping';
			$segments[] ="account-shipping";
			if(isset($query['next_page']) )	{
				$segments[] = "checkout";
				unset($query['next_page']);
			}
		break;



		case 'shop.registration';
			$segments[] ="user-registration";
		break;


		case 'shop.recommend';
			$segments[] ="recommend";

			if(isset($query['tmpl']) )	{
				$segments[] = $query['tmpl'];
				unset($query['tmpl']);
			}

			if(isset($query['pop']) )	{
				$segments[] = $query['pop'];
				unset($query['pop']);
			}

			if(isset($query['product_id']) ){
				$segments[] = $query['product_id'];
				$product_alias = getProductTitle($query['product_id']);
				$segments[] = $product_alias;
				unset($query['product_id']);
			}

		break;


		case 'shop.tos';
			$segments[] ="terms-of-service";
		break;

		case 'shop.cart';
			$segments[] ="cart";
		break;

		case 'account.index';
			$segments[] ="account";
		break;



		case 'account.order_details';
			$segments[] ="order-details";
			if(isset($query['order_id']))	{
				$segments[] = $query['order_id'];
				unset($query['order_id']);
			}
		break;


		case 'shop.waiting_list';
			$segments[] ="notify";
			if(isset($query['product_id']))	{
				$segments[] = $query['product_id'];
				$product_id_exists = true;
				$pid = $query['product_id'];
				unset($query['product_id']);
			}

			if($product_id_exists)	{
				$product_alias = getProductTitle($pid);
				$segments[] = $product_alias;
			}
		break;

		case 'shop.search';
			$segments[] =PAGE_ADVANCE_SEARCH;
		break;

		case 'store.index';
			$segments[] = 'administration';
		break;

		case 'account.favorite_products';
			$segments[] ="favoritos";
		break;

	}

	return $segments;
}
/*End of the function*/



function virtuemartParseRoute($segments)
{

	$vars = array();

	$firstSegment = $segments[0];
	switch($firstSegment){

		case PAGE_SHOP_BROWSE:
			$vars['page'] = "shop.browse";
			if(isset($segments[1])){
				$vars['category_id'] = $segments[1];
			}
		break;

		/*This is for all products page*/
		case 'products':
			$vars['page'] = "shop.browse";
			$vars['category'] = "";
		break;


		case PAGE_SHOP_FEED:
			$vars['page'] = "shop.feed";
			if(isset($segments[1])){
				$vars['category_id'] = $segments[1];
			}

		break;

		case PAGE_PRODUCT_DETAILS:
			$vars['page'] = "shop.product_details";

			if(isset($segments[1])){
				$vars['product_id'] = $segments[1];
			}

			if(isset($segments[2])){
				$vars['category_id'] = $segments[2];
			}


		break;

		case PAGE_PRODUCT_ENQUIRY:
			$vars['page'] = "shop.ask";
			$vars['category_id'] = $segments[1];
			$vars['product_id'] = $segments[2];
		break;

		case PAGE_CHECKOUT_INDEX:
			$vars['page'] = "checkout.index";

			if(isset($segments[1]) && ($segments[1]=="ssl_redirect")){
				$vars['ssl_redirect'] = 1;

			}

			if(isset($segments[2]) && ($segments[2]=="redirected")){
				$vars['redirected'] = 1;
			}
		break;

		case 'account:billing':
			$vars['page'] = "account.billing";
			if(isset($segments[1])){
				$vars['next_page'] = "checkout.index";
			}
		break;

		case 'account:shipto':
			$vars['page'] = "account.shipto";
			if($segments[1]){
				$vars['next_page'] = "checkout.index";
			}
		break;

		case 'account:shipping':
			$vars['page'] = "account.shipping";
			if($segments[1]){
				$vars['next_page'] = "checkout.index";
			}
		break;




		case 'recommend';
			$vars['page'] = "shop.recommend";
			$vars['pop'] = 1;
			$vars['product_id'] = $segments[3];
			$vars['tmpl']= "component";
		break;


		case 'user:registration';
			$vars['page'] = "shop.registration";
		break;



		case 'account':
			$vars['page'] = "account.index";
		break;


		case 'cart':
			$vars['page'] = "shop.cart";
		break;


		case 'order:details':
			$vars['page'] = "account.order_details";
			$vars['order_id'] = $segments[1];
		break;

		case 'temrs:of:service':
			$vars['page'] = "shop.tos";
		break;



		case 'notify':
			$vars['page'] = "shop.waiting_list";
			$vars['product_id'] = $segments[1];
		break;

		case PAGE_ADVANCE_SEARCH:
			$vars['page'] = "shop.search";

		break;

		case 'administration':
			$vars['page'] = "store.index";
			$vars['pshop_mode'] = "admin";

		break;

		case 'favoritos';
			$vars['page'] ="account.favorite_products";
		break;

	}
	return $vars;
}


/*
This function returns category/subcatgory alias string
*/

function getCategoryTitle($id){
	$db			= & JFactory::getDBO();

	$query = "
			SELECT t1.category_child_id AS lev1, t2.category_child_id as lev2, t3.category_child_id as lev3
			FROM  #__vm_category_xref AS t1
			LEFT JOIN #__vm_category_xref AS t2 ON t2.category_child_id = t1.category_parent_id
			LEFT JOIN #__vm_category_xref AS t3 ON t3.category_child_id = t2.category_parent_id
			WHERE t1.category_child_id= ".$id;

	$db->setQuery($query);
	$nestedCategoryIds = $db->loadObject();
	if($nestedCategoryIds=="")
		return;

	$catIdsArr = array();

	if($nestedCategoryIds->lev3){
		$catIdsArr[] = $nestedCategoryIds->lev3;
	}

	if($nestedCategoryIds->lev2){
		$catIdsArr[] = $nestedCategoryIds->lev2;
	}

	if($nestedCategoryIds->lev1){
		$catIdsArr[] = $nestedCategoryIds->lev1;
	}

	$catIdsStr = implode( ',', $catIdsArr );

	$query = "SELECT GROUP_CONCAT( category_name
			SEPARATOR  '/' )
			FROM #__vm_category
			WHERE category_id IN (".$catIdsStr.")";



	$db->setQuery($query);
	$category_name = $db->loadResult();
	$category_alias = strtolower($category_name);
	//Pablo. Para quitar los acentos
	$category_alias = str_replace('/','xy1yx', $category_alias);
	$category_alias = JFilterOutput::stringURLSafe($category_alias);
	$category_alias = str_replace('xy1yx', '/', $category_alias);

	//Remove following characters
	$special_chars = array('!','@','#','$','%','*','(',')');
	foreach($special_chars as $char){
		$category_alias = str_replace($char,'', $category_alias);
	}

	$category_alias = str_replace(' ','-', $category_alias);
	$category_alias = str_replace('  ','-', $category_alias);

	return $category_alias;
}



function getProductTitle($id){
	$db			= & JFactory::getDBO();
	// gets category name
	$query = 'SELECT product_name FROM #__vm_product  ' .
	' WHERE product_id = ' . (int) $id;

	$db->setQuery($query);
	// gets category name of item
	$product_name = $db->loadResult();
	$product_name = strtolower($product_name);
	//Pablo. Para quitar los acentos
	$product_name = JFilterOutput::stringURLSafe($product_name);

	//Remove following characters
	$special_chars = array('!','@','#','$','%','*','(',')');
	foreach($special_chars as $char){
		$product_name = str_replace($char,'', $product_name);
	}

	$product_name = str_replace(' ','-', $product_name);
	$product_name = str_replace('  ','-', $product_name);

	return $product_name;
}

/*
function getmanufacturerName($id){
	$db			= & JFactory::getDBO();
	// gets category name
	$query = 'SELECT mf_name FROM #__vm_manufacturer   ' .
	' WHERE manufacturer_id = ' . (int) $id;
	echo $query;die();
	$db->setQuery($query);
	// gets category name of item
	$mf_name = $db->loadResult();
	$mf_name = strtolower($product_name);
	//Pablo. Para quitar los acentos
	$mf_name = JFilterOutput::stringURLSafe($mf_name);

	//Remove following characters
	$special_chars = array('!','@','#','$','%','*','(',')');
	foreach($special_chars as $char){
		$mf_name = str_replace($char,'', $mf_name);
	}

	$mf_name = str_replace(' ','-', $mf_name);
	$mf_name = str_replace('  ','-', $mf_name);

	return $mf_name;
}
*/
?>