<?php
/**
 * Plugin Name: WooCommerce Order Archiver Ultimate Pro - Final
 * Description: Archiva pedidos antiguos de WooCommerce con listado de pedidos archivados, export CSV, reactivación, cron automático, panel de configuración y miniaturas de productos.
 * Version: 2.2
 * Author: Tu Nombre
 */

if (!defined('ABSPATH')) exit;

global $wc_archiver_pro_cron_hook;
$wc_archiver_pro_cron_hook = 'wc_archiver_pro_daily_cron';

// --- FUNCIONES ---
function wc_archiver_pro_create_tables() {
    global $wpdb;
    $posts_table = $wpdb->prefix . 'posts_archive';
    $postmeta_table = $wpdb->prefix . 'postmeta_archive';

    $wpdb->query("CREATE TABLE IF NOT EXISTS {$posts_table} LIKE {$wpdb->prefix}posts");
    $wpdb->query("CREATE TABLE IF NOT EXISTS {$postmeta_table} LIKE {$wpdb->prefix}postmeta");
    $wpdb->query("ALTER TABLE {$posts_table} ADD INDEX IF NOT EXISTS post_type_status_date_idx (post_type, post_status, post_date)");
    $wpdb->query("ALTER TABLE {$postmeta_table} ADD INDEX IF NOT EXISTS post_id_idx (post_id)");
    $wpdb->query("ALTER TABLE {$postmeta_table} ADD INDEX IF NOT EXISTS meta_key_idx (meta_key(191))");
}

function wc_archiver_pro_archive_orders() {
    global $wpdb;
    wc_archiver_pro_create_tables();

    $years = get_option('wc_archiver_years', 2);
    $statuses = get_option('wc_archiver_statuses', ['wc-completed','wc-cancelled']);
    if(empty($statuses)) return;
    $statuses_sql = "'".implode("','",$statuses)."'";
    $cutoff_date = date('Y-m-d H:i:s', strtotime('-'.$years.' years'));

    $posts_table = $wpdb->prefix . 'posts_archive';
    $postmeta_table = $wpdb->prefix . 'postmeta_archive';

    $wpdb->query("INSERT INTO {$posts_table} SELECT * FROM {$wpdb->prefix}posts WHERE post_type='shop_order' AND post_status IN ($statuses_sql) AND post_date<'{$cutoff_date}'");
    $wpdb->query("INSERT INTO {$postmeta_table} SELECT pm.* FROM {$wpdb->prefix}postmeta pm INNER JOIN {$wpdb->prefix}posts p ON p.ID=pm.post_id WHERE p.post_type='shop_order' AND p.post_status IN ($statuses_sql) AND p.post_date<'{$cutoff_date}'");
    $wpdb->query("DELETE pm FROM {$wpdb->prefix}postmeta pm INNER JOIN {$wpdb->prefix}posts p ON p.ID=pm.post_id WHERE p.post_type='shop_order' AND post_status IN ($statuses_sql) AND post_date<'{$cutoff_date}'");
    $wpdb->query("DELETE FROM {$wpdb->prefix}posts WHERE post_type='shop_order' AND post_status IN ($statuses_sql) AND post_date<'{$cutoff_date}'");

    if(is_admin() && isset($_GET['action']) && $_GET['action']=='wc_archive_orders'){
        wp_redirect(admin_url('admin.php?page=wc_archiver_orders_final&archived=1'));
        exit;
    }
}

function wc_archiver_pro_show_orders() {
    global $wpdb;
    $posts_table = $wpdb->prefix . 'posts_archive';
    $per_page = get_option('wc_archiver_per_page', 50);
    $paged = isset($_GET['paged']) ? max(1,intval($_GET['paged'])) : 1;
    $offset = ($paged-1) * $per_page;

    echo '<div style="margin-bottom:15px;">';
    echo '<a class="button button-primary" href="'.admin_url('admin-post.php?action=wc_archive_orders').'">Archivar pedidos antiguos</a>';
    echo '</div>';

    $total = $wpdb->get_var("SELECT COUNT(*) FROM {$posts_table} WHERE post_type='shop_order'");
    $orders = $wpdb->get_results($wpdb->prepare(
        "SELECT * FROM {$posts_table} WHERE post_type='shop_order' ORDER BY post_date DESC LIMIT %d OFFSET %d",
        $per_page, $offset
    ));

    echo '<table class="wp-list-table widefat fixed striped">';
    echo '<thead><tr><th>ID</th><th>Pedido</th><th>Fecha</th><th>Estado</th><th>Acciones</th></tr></thead><tbody>';

    if($orders) {
        foreach($orders as $order){
            echo '<tr>';
            echo '<td>'.esc_html($order->ID).'</td>';
            echo '<td>'.esc_html($order->post_title).'</td>';
            echo '<td>'.esc_html($order->post_date).'</td>';
            echo '<td>'.esc_html($order->post_status).'</td>';
            echo '<td><a href="'.get_edit_post_link($order->ID).'" target="_blank">Ver</a></td>';
            echo '</tr>';
        }
    } else {
        echo '<tr><td colspan="5">No hay pedidos archivados</td></tr>';
    }

    echo '</tbody></table>';

    $total_pages = ceil($total / $per_page);
    if($total_pages>1){
        $base = admin_url('admin.php?page=wc_archiver_orders_final');
        echo '<div class="tablenav"><div class="tablenav-pages">';
        for($i=1;$i<=$total_pages;$i++){
            if($i==$paged){
                echo "<span class='page-numbers current'>$i</span> ";
            } else {
                echo "<a class='page-numbers' href='".esc_url(add_query_arg('paged',$i,$base))."'>$i</a> ";
            }
        }
        echo '</div></div>';
    }
}

function wc_archiver_settings_page() {
    if (isset($_POST['wc_archiver_save_settings'])) {
        check_admin_referer('wc_archiver_settings_save','wc_archiver_nonce');
        update_option('wc_archiver_years', intval($_POST['wc_archiver_years']));
        update_option('wc_archiver_statuses', array_map('sanitize_text_field',(array)$_POST['wc_archiver_statuses']));
        update_option('wc_archiver_cron', isset($_POST['wc_archiver_cron']) ? 1 : 0);
        update_option('wc_archiver_per_page', intval($_POST['wc_archiver_per_page']));
        echo '<div class="notice notice-success"><p>Ajustes guardados correctamente.</p></div>';
    }

    $years = get_option('wc_archiver_years',2);
    $statuses = get_option('wc_archiver_statuses',['wc-completed','wc-cancelled']);
    $cron = get_option('wc_archiver_cron',1);
    $per_page = get_option('wc_archiver_per_page',50);
    $all_statuses = wc_get_order_statuses();
    ?>
    <div class="wrap"><h1>Ajustes Archivero WooCommerce</h1>
    <form method="post">
        <?php wp_nonce_field('wc_archiver_settings_save','wc_archiver_nonce'); ?>
        <table class="form-table">
            <tr>
                <th>Años para archivar pedidos</th>
                <td><input type="number" name="wc_archiver_years" value="<?php echo esc_attr($years); ?>" min="1"></td>
            </tr>
            <tr>
                <th>Estados de pedidos a archivar</th>
                <td>
                    <?php foreach($all_statuses as $key=>$label): ?>
                        <label><input type="checkbox" name="wc_archiver_statuses[]" value="<?php echo esc_attr($key); ?>" <?php checked(in_array($key,$statuses)); ?>> <?php echo esc_html($label); ?></label><br>
                    <?php endforeach; ?>
                </td>
            </tr>
            <tr>
                <th>Cron automático activo</th>
                <td><input type="checkbox" name="wc_archiver_cron" value="1" <?php checked($cron,1); ?>></td>
            </tr>
            <tr>
                <th>Pedidos por página en listado archivado</th>
                <td><input type="number" name="wc_archiver_per_page" value="<?php echo esc_attr($per_page); ?>" min="10"></td>
            </tr>
        </table>
        <p><button class="button button-primary" type="submit" name="wc_archiver_save_settings">Guardar ajustes</button></p>
    </form>
    </div>
    <?php
}

// --- ACTIVACIÓN / DESACTIVACIÓN ---
register_activation_hook(__FILE__, function(){
    wc_archiver_pro_create_tables();
    if(!wp_next_scheduled($GLOBALS['wc_archiver_pro_cron_hook'])){
        wp_schedule_event(time(),'daily',$GLOBALS['wc_archiver_pro_cron_hook']);
    }
});
register_deactivation_hook(__FILE__, function(){
    wp_clear_scheduled_hook($GLOBALS['wc_archiver_pro_cron_hook']);
});

// --- Menú principal WordPress ---
add_action('admin_menu', function(){
    add_menu_page(
        'Pedidos Archivados',
        'Pedidos Archivados',
        'manage_woocommerce',
        'wc_archiver_orders_final',
        'wc_archiver_pro_show_orders',
        'dashicons-archive',
        56
    );
    add_submenu_page(
        'wc_archiver_orders_final',
        'Ajustes Archivero',
        'Ajustes Archivero',
        'manage_options',
        'wc_archiver_settings',
        'wc_archiver_settings_page'
    );
});

// --- ADMIN POST PARA ARCHIVAR ---
add_action('admin_post_wc_archive_orders','wc_archiver_pro_archive_orders');

// --- CRON ---
add_action('wc_archiver_pro_daily_cron','wc_archiver_pro_archive_orders');